/* JAlbum tool that renames slide specific varibles */

import se.datadosen.jalbum.*;
import se.datadosen.component.*;

ControlPanel panel = new ControlPanel() {
	JTextField search = new JTextField(10);
	JTextField replace = new JTextField(10);
	{
		add(new JLabel("Search"));
		add("tab", search);
		add("br", new JLabel("Replace"));
		add("tab", replace);
	}
};

var renameCount = 0;

void processFolder(AlbumObject folder) {
	for (AlbumObject ao : folder.getChildren()) {
		AlbumObjectProperties props = ao.getProperties();
		if (props.containsKey(search)) {
			Object value = props.get(search);
			props.put(replace, value);
			props.remove(search);
			props.save();
			renameCount++;
		}

		if (ao.isFolder()) {
			processFolder(ao);
		}
	}
}

// Execution starts here
msg =
"This script renames slide specific variables of the current album";
int option = JOptionPane.showConfirmDialog(window, panel, "Rename slide variables of the current album", JOptionPane.OK_CANCEL_OPTION, JOptionPane.INFORMATION_MESSAGE);
if (option != JOptionPane.YES_OPTION) return;

var search = panel.search.getText();
var replace = panel.replace.getText();

if (search.length() == 0 || replace.length() == 0) {
	window.messageBox("You need to fill in names for both the search and replace fields");
	throw new OperationAbortedException();
}

processFolder(rootFolder);
window.statusBar.setText("Renamed " + renameCount + " variables");
